/*
 * Decompiled with CFR 0.152.
 */
package wmsturbochallenge;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import wmsplugin.WMSLayer;
import wmsturbochallenge.WMSRacer;
import wmsturbochallenge.engine;
import wmsturbochallenge.fake_map_view;

public class GameWindow
extends JFrame
implements ActionListener {
    protected engine car_engine;
    protected gps car_gps;
    protected double lat;
    protected double lon;
    protected double ele = 3.0E-6;
    protected double horizon = 0.63;
    protected double cardist = this.ele * 3.0;
    protected int scale = 5;
    protected BufferedImage screen_image;
    protected Graphics screen;
    protected int width = 320;
    protected int height = 200;
    protected int centre = this.width / 2;
    protected static final ImageIcon[] car = new ImageIcon[]{new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/car-l.png"))), new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/car.png"))), new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/car-r.png")))};
    protected static final ImageIcon[] bg = new ImageIcon[]{new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/bg0.png")))};
    protected static final ImageIcon loading = new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSRacer.class.getResource("/images/loading.png")));
    protected int current_bg;
    protected Layer ground;
    protected double heading = 0.0;
    protected double wheelangle = 0.0;
    protected double speed = 0.0;
    protected boolean[] key_down = new boolean[]{false, false, false, false};
    int frame;
    boolean downloading = false;
    public boolean no_super_repaint = false;
    JPanel panel = new GamePanel();
    protected Timer timer;
    protected fake_map_view ground_view;
    protected static Toolkit s = Toolkit.getDefaultToolkit();

    public GameWindow(Layer ground) {
        this.setTitle("The Ultimate WMS Super-speed Turbo Challenge II");
        this.setDefaultCloseOperation(2);
        this.setUndecorated(true);
        this.setSize(GameWindow.s.getScreenSize().width, GameWindow.s.getScreenSize().height);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        while (GameWindow.s.getScreenSize().width < this.width * this.scale || GameWindow.s.getScreenSize().height < this.height * this.scale) {
            --this.scale;
        }
        this.add(this.panel);
        this.setVisible(true);
        this.screen_image = new BufferedImage(this.width, this.height, 1);
        this.screen = this.screen_image.getGraphics();
        this.ground = ground;
        this.ground_view = new fake_map_view(Main.map.mapView, 1.0E-7);
        EastNorth start = this.ground_view.parent.getCenter();
        this.lat = start.north();
        this.lon = start.east();
        this.addKeyListener(new TAdapter());
        this.timer = new Timer(80, this);
        this.timer.start();
        this.car_gps = new gps();
        this.car_gps.start();
        this.car_engine = new engine();
        this.car_engine.start();
    }

    protected void move() {
        if (this.key_down[0]) {
            this.wheelangle -= 0.1 / (1.0 + Math.abs(this.speed));
        }
        if (this.key_down[1]) {
            this.wheelangle += 0.1 / (1.0 + Math.abs(this.speed));
        }
        if (this.wheelangle > 0.3) {
            this.wheelangle = 0.3;
        }
        if (this.wheelangle < -0.3) {
            this.wheelangle = -0.3;
        }
        this.wheelangle *= 0.7;
        if (this.key_down[2]) {
            this.speed += this.speed >= 0.0 ? 1.0 / (2.0 + this.speed) : 0.5;
        }
        if (this.key_down[3]) {
            this.speed = this.speed >= 0.5 ? (this.speed -= 0.5) : (this.speed >= 0.01 ? 0.0 : (this.speed -= 0.5 / (4.0 - this.speed)));
        }
        this.speed *= 0.97;
        this.car_engine.set_speed(this.speed);
        if (this.speed > -0.1 && this.speed < 0.1) {
            this.speed = 0.0;
        }
        this.heading += this.wheelangle * this.speed;
        this.lat += Math.cos(this.heading) * this.speed * this.ele * 0.2;
        this.lon += Math.sin(this.heading) * this.speed * this.ele * 0.2;
    }

    protected void screen_repaint() {
        this.screen.drawImage(bg[this.current_bg].getImage(), 0, 0, this);
        this.ground_paint();
        ++this.frame;
        if ((this.frame & 8) == 0 && this.downloading) {
            this.screen.drawImage(loading.getImage(), this.centre - loading.getIconWidth() / 2, 50, this);
        }
        int orientation = this.wheelangle > -0.05 ? (this.wheelangle < 0.05 ? 1 : 2) : 0;
        this.screen.drawImage(car[orientation].getImage(), this.centre - car[orientation].getIconWidth() / 2, this.height - car[orientation].getIconHeight() - 10, this);
    }

    static double max3(double[] x) {
        return x[0] > x[1] ? (x[2] > x[0] ? x[2] : x[0]) : (x[2] > x[1] ? x[2] : x[1]);
    }

    static double min3(double[] x) {
        return x[0] < x[1] ? (x[2] < x[0] ? x[2] : x[0]) : (x[2] < x[1] ? x[2] : x[1]);
    }

    protected void ground_paint() {
        double sin = Math.sin(this.heading);
        double cos = Math.cos(this.heading);
        double maxdist = this.ele / (this.horizon - 0.6);
        double left_x = maxdist * (double)(this.width - this.centre) / (double)this.height;
        double right_x = maxdist * (double)(0 - this.centre) / (double)this.height;
        double[] e_lat = new double[]{this.lat + (maxdist - this.cardist) * cos - left_x * sin, this.lat + (maxdist - this.cardist) * cos - right_x * sin, this.lat - this.cardist * cos};
        double[] e_lon = new double[]{this.lon + (maxdist - this.cardist) * sin + left_x * cos, this.lon + (maxdist - this.cardist) * sin + right_x * cos, this.lon - this.cardist * sin};
        this.ground_view.setProjectionBounds(new ProjectionBounds(new EastNorth(GameWindow.min3(e_lon), GameWindow.min3(e_lat)), new EastNorth(GameWindow.max3(e_lon), GameWindow.max3(e_lat))));
        if (this.ground instanceof WMSLayer) {
            WMSLayer wms = (WMSLayer)this.ground;
            this.downloading = wms.hasAutoDownload() && (null == wms.findImage(new EastNorth(e_lon[0], e_lat[0])) || null == wms.findImage(new EastNorth(e_lon[0], e_lat[0])) || null == wms.findImage(new EastNorth(e_lon[0], e_lat[0])));
        }
        this.ground.paint(this.ground_view.graphics, (MapView)this.ground_view, null);
        for (int y = (int)((double)this.height * this.horizon + 0.1); y < this.height; ++y) {
            double dist = this.ele / (1.0 * (double)y / (double)this.height - 0.6);
            double lat_off = this.lat + (dist - this.cardist) * cos;
            double lon_off = this.lon + (dist - this.cardist) * sin;
            for (int x = 0; x < this.width; ++x) {
                double p_x = dist * (double)(x - this.centre) / (double)this.height;
                EastNorth en = new EastNorth(lon_off + p_x * cos, lat_off - p_x * sin);
                Point pt = this.ground_view.getPoint(en);
                int rgb = this.ground_view.ground_image.getRGB(pt.x, pt.y);
                this.screen_image.setRGB(x, y, rgb);
            }
        }
    }

    protected void quit() {
        this.timer.stop();
        this.car_engine.stop();
        this.car_gps.stop();
        this.car_gps.save_trace();
        this.setVisible(false);
        this.panel = null;
        this.screen_image = null;
        this.screen = null;
        this.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        this.move();
        this.screen_repaint();
        this.no_super_repaint = true;
        this.panel.repaint();
    }

    protected static ImageIcon get_image(String name) {
        return new ImageIcon(s.createImage(WMSRacer.class.getResource("/image/" + name)));
    }

    protected class TAdapter
    extends KeyAdapter {
        protected TAdapter() {
        }

        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            if (key == 37 && !GameWindow.this.key_down[0]) {
                GameWindow.this.wheelangle -= 0.02;
                GameWindow.this.key_down[0] = true;
            }
            if (key == 39 && !GameWindow.this.key_down[1]) {
                GameWindow.this.wheelangle += 0.02;
                GameWindow.this.key_down[1] = true;
            }
            if (key == 38) {
                GameWindow.this.key_down[2] = true;
            }
            if (key == 40) {
                GameWindow.this.key_down[3] = true;
            }
            if (key == 27) {
                GameWindow.this.quit();
            }
            if (key == 83) {
                if (GameWindow.this.car_engine.is_on()) {
                    GameWindow.this.car_engine.stop();
                } else {
                    GameWindow.this.car_engine.start();
                }
            }
        }

        public void keyReleased(KeyEvent e) {
            int key = e.getKeyCode();
            if (key == 37) {
                GameWindow.this.key_down[0] = false;
            }
            if (key == 39) {
                GameWindow.this.key_down[1] = false;
            }
            if (key == 38) {
                GameWindow.this.key_down[2] = false;
            }
            if (key == 40) {
                GameWindow.this.key_down[3] = false;
            }
        }
    }

    protected class GamePanel
    extends JPanel {
        public GamePanel() {
            this.setBackground(Color.BLACK);
            this.setDoubleBuffered(true);
        }

        public void paint(Graphics g) {
            int w = (int)this.getSize().getWidth();
            int h = (int)this.getSize().getHeight();
            if (GameWindow.this.no_super_repaint) {
                GameWindow.this.no_super_repaint = false;
            } else {
                super.paint(g);
            }
            g.drawImage(GameWindow.this.screen_image, (w - GameWindow.this.width * GameWindow.this.scale) / 2, (h - GameWindow.this.height * GameWindow.this.scale) / 2, GameWindow.this.width * GameWindow.this.scale, GameWindow.this.height * GameWindow.this.scale, this);
            Toolkit.getDefaultToolkit().sync();
        }
    }

    protected class gps
    extends Timer
    implements ActionListener {
        protected GpxTrack track;
        protected Collection<WayPoint> segment;

        public gps() {
            super(1000, null);
            this.addActionListener(this);
            this.track = new GpxTrack();
        }

        public void actionPerformed(ActionEvent e) {
            this.segment.add(new WayPoint(Main.proj.eastNorth2latlon(new EastNorth(GameWindow.this.lon, GameWindow.this.lat))));
        }

        public void start() {
            super.start();
            this.segment = new ArrayList<WayPoint>();
            this.track.trackSegs.add(this.segment);
            this.actionPerformed(null);
        }

        public void save_trace() {
            int len = 0;
            for (Collection seg : this.track.trackSegs) {
                len += seg.size();
            }
            if (len <= 5) {
                return;
            }
            GpxData data = new GpxData();
            data.tracks.add(this.track);
            GameWindow.this.ground_view.parent.addLayer((Layer)new GpxLayer(data, "Car GPS trace"));
        }
    }
}

